import { logger } from "genkit/logging";
import { toDisplayPath } from "genkit/tracing";
import {
  createCommonLogAttributes,
  extractOuterFeatureNameFromPath,
  truncate,
  truncatePath
} from "../utils.js";
class ActionTelemetry {
  tick(span, logInputAndOutput, projectId) {
    if (!logInputAndOutput) {
      return;
    }
    const attributes = span.attributes;
    const actionName = attributes["genkit:name"] || "<unknown>";
    const subtype = attributes["genkit:metadata:subtype"];
    if (subtype === "tool" || actionName === "generate") {
      const path = attributes["genkit:path"] || "<unknown>";
      const input = truncate(attributes["genkit:input"]);
      const output = truncate(attributes["genkit:output"]);
      const sessionId = attributes["genkit:sessionId"];
      const threadName = attributes["genkit:threadName"];
      let featureName = extractOuterFeatureNameFromPath(path);
      if (!featureName || featureName === "<unknown>") {
        featureName = actionName;
      }
      if (input) {
        this.writeLog(
          span,
          "Input",
          featureName,
          path,
          input,
          projectId,
          sessionId,
          threadName
        );
      }
      if (output) {
        this.writeLog(
          span,
          "Output",
          featureName,
          path,
          output,
          projectId,
          sessionId,
          threadName
        );
      }
    }
  }
  writeLog(span, tag, featureName, qualifiedPath, content, projectId, sessionId, threadName) {
    const path = truncatePath(toDisplayPath(qualifiedPath));
    const sharedMetadata = {
      ...createCommonLogAttributes(span, projectId),
      path,
      qualifiedPath,
      featureName,
      sessionId,
      threadName
    };
    logger.logStructured(`${tag}[${path}, ${featureName}]`, {
      ...sharedMetadata,
      content
    });
  }
}
const actionTelemetry = new ActionTelemetry();
export {
  actionTelemetry
};
//# sourceMappingURL=action.mjs.map